import React, { useEffect } from "react";
import { Image, View } from "react-native";
import ImageCarousel from "./ImageCarousel";
import SkeletonElement from "../../../src/skeletons/SkeletonElement";
import { useDispatch } from "react-redux";
import { getHomeBanner } from "../../../redux/slices/homeBanner/homeBanner";
import { useSelector } from "react-redux";
import { bannerStyle } from "./homeBannerStyle";

const img = Image.resolveAssetSource(
    require("../../../assets/images/image-loader-icon.png")
).uri;

const HomeBanner = () => {
    const dispatch = useDispatch();
    const { banner, loading } = useSelector((state) => state.homeBannerReducer);

    useEffect(() => {
        let isMounted = true;

        if (isMounted) {
            dispatch(getHomeBanner());
        }
        return () => {
            isMounted = false;
        };
    }, [banner]);

    return (
        <View>
            {loading && banner?.length === 0 ? (
                <SkeletonElement wrapperStyle={bannerStyle.skeletonWrapper}/>
            ) : banner?.length > 0 ? (
                <ImageCarousel
                    data={banner}
                    autoPlay={true}
                    pagination={true}
                />
            ) : (
                <>
                    {img && <Image source={{ uri: img }} style={bannerStyle.defaultImage} />}
                </>
            )}
        </View>
    );
};

export default HomeBanner;
